#include <xc.h>

#define IIC_WRITE_ADDRESS   0x09
#define IIC_WRITE_DATA      0x29
#define IIC_READ_ADDRESS    0x0C
#define IIC_READ_DATA       0x2C
#define IIC_NACK            0x28

unsigned char SSP_STATUS;
unsigned char SSP_ADDRESS;
unsigned char SSP_BUFFER;
unsigned char SSP_INDEX;
unsigned char SSP_SFR_ADDRESS;
//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
void IIC_Handler(void)
{
  if (SSPSTATbits.R_nW)
  {
      SSP_STATUS = SSPSTAT & 0x2C;
  }
  else
  {
      SSP_STATUS = SSPSTAT & 0x2D;
  }

  switch (SSP_STATUS)
  {
      case IIC_WRITE_ADDRESS:
          SSP_ADDRESS = SSPBUF;
          SSP_INDEX = 0x00;
          break;
      case IIC_WRITE_DATA:
          if(SSP_ADDRESS & 0x02)
          {
              STATUSbits.IRP = 1;
          }
          else
          {
              STATUSbits.IRP = 0;
          }
          if (!SSP_INDEX)
          {
              SSP_SFR_ADDRESS = SSPBUF;
              SSP_INDEX = SSP_INDEX + 1;
          }
          else
          {
              FSR = SSP_SFR_ADDRESS;
              INDF = SSPBUF;
              SSP_SFR_ADDRESS = SSP_SFR_ADDRESS + 1;
          }
          break;
      case IIC_READ_ADDRESS:
          SSP_ADDRESS = SSPBUF;
          if(SSP_ADDRESS & 0x02)
          {
              STATUSbits.IRP = 1;
          }
          else
          {
              STATUSbits.IRP = 0;
          }
          SSP_BUFFER = SSPBUF;
          FSR = SSP_SFR_ADDRESS;
          while(SSPSTATbits.BF);
          SSPCON1bits.WCOL = 0;
          SSPBUF = INDF;
          while(SSPCON1bits.WCOL)
          {
              SSPCON1bits.WCOL = 0;
              SSPBUF = 0;
          }
          break;
      case IIC_READ_DATA:
          if(SSP_ADDRESS & 0x02)
          {
              STATUSbits.IRP = 1;
          }
          else
          {
              STATUSbits.IRP = 0;
          }
          SSP_SFR_ADDRESS = SSP_SFR_ADDRESS + 1;
          FSR = SSP_SFR_ADDRESS;
          while(SSPSTATbits.BF);
          SSP_BUFFER = SSPBUF;
          while(SSPSTATbits.BF);
          SSPCON1bits.WCOL = 0;
          SSPBUF = 0;
          while(SSPCON1bits.WCOL)
          {
              SSPCON1bits.WCOL = 0;
              SSPBUF = INDF;
          }
          break;
      case IIC_NACK:
          SSP_BUFFER = SSPBUF;
          break;
      default:
          SSPCON1 = 0x00;
          SSP_BUFFER = SSPBUF;
          SSPSTAT = 0x00;
          SSPCON2 = 0x00;
          SSPCON3 = 0x00;
          SSPCON1 = 0x36;
  }

}

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
